﻿using System;
using System.Windows;
using System.Windows.Controls;
using Microsoft.Phone.Controls;
using RssReader.ViewModels;

namespace RssReader.Views
{
    public partial class MainPage : PhoneApplicationPage
    {
        // Constructor
        public MainPage()
        {
            InitializeComponent();
            DataContext = new MainViewModel();
            Loaded += new RoutedEventHandler(OnMainPage_Loaded);
            PageTransitionList.Completed += new EventHandler(OnPageTransitionList_Completed);
        }

        private void NewsListBox_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {
            // Start page transition animation
            PageTransitionList.Begin();
        }

        private void OnPageTransitionList_Completed(object sender, EventArgs e)
        {
            ((MainViewModel)DataContext).SelectedItem = (RssItemViewModel)newsListBox.SelectedItem;
            NavigationService.Navigate(new Uri("/Views/DetailsPage.xaml", UriKind.Relative));
            FrameworkElement root = Application.Current.RootVisual as FrameworkElement;
            root.DataContext = ((MainViewModel)DataContext).SelectedItem;
        }

        private void OnMainPage_Loaded(object sender, RoutedEventArgs e)
        {
            ResetPageTransitionList.Begin();
        }
    }
}